package cn.com.grandage.ssedemo.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class DifyRequest {

    private String query;
    private Map<String, Object> inputs = Map.of();

    @JsonProperty("response_mode")
    private String responseMode = "streaming"; // 默认流式模式
    private String user;

    @JsonProperty("conversation_id")
    private String conversationId = ""; // 默认空字符串

    private Object files;
    
    @JsonProperty("auto_generate_name")
    private Boolean autoGenerateName = true; // 默认自动生成名称

    @JsonProperty("workflow_id")
    private String workflowId;

    @JsonProperty("trace_id")
    private String traceId;

    // 构造函数
    public DifyRequest() {
    }

    public DifyRequest(String query, String user) {
        this.query = query;
        this.user = user;
    }

    // Getters and Setters
    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Map<String, Object> getInputs() {
        return inputs;
    }

    public void setInputs(Map<String, Object> inputs) {
        this.inputs = inputs;
    }

    public String getResponseMode() {
        return responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getConversationId() {
        return conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public Object getFiles() {
        return files;
    }

    public void setFiles(Object files) {
        this.files = files;
    }

    public Boolean getAutoGenerateName() {
        return autoGenerateName;
    }

    public void setAutoGenerateName(Boolean autoGenerateName) {
        this.autoGenerateName = autoGenerateName;
    }

    public String getWorkflowId() {
        return workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Override
    public String toString() {
        return "DifyRequest{" +
                "query='" + query + '\'' +
                ", inputs=" + inputs +
                ", responseMode='" + responseMode + '\'' +
                ", user='" + user + '\'' +
                ", conversationId='" + conversationId + '\'' +
                ", files=" + files +
                ", autoGenerateName=" + autoGenerateName +
                ", workflowId='" + workflowId + '\'' +
                ", traceId='" + traceId + '\'' +
                '}';
    }
}