# React-SpringBoot SSE Chat Demo for Ningbo Bank Youyun

## 项目背景

这是一个为宁波银行优云平台提供的Dify接口演示项目。项目基于React前端和Spring Boot后端，使用Server-Sent Events (SSE)技术实现与Dify AI服务的实时通信。该演示项目展示了如何通过SSE技术实现流式消息传输，为银行客户提供智能化的对话服务体验。

## 功能特性

- 实时聊天功能：用户可以与AI助手进行实时对话
- SSE流式消息传输：通过Server-Sent Events实现消息的流式传输，提升用户体验
- 消息思考过程展示：可视化展示AI的思考过程
- 响应式UI设计：适配不同屏幕尺寸的设备
- 跨域支持：支持前后端分离部署

## 技术栈

### 前端 (React)
- React 19
- TypeScript 4
- react-markdown 10
- remark-gfm 4
- react-syntax-highlighter 15

### 后端 (Spring Boot)
- Spring Boot
- Java 17+
- WebClient (用于调用Dify API)
- Gradle构建工具

## 项目结构

```
react-springbot-sse-chat/
├── react-frontend/     # React 前端应用
├── sse-demo/          # Spring Boot 后端服务
└── README.md
```

## 快速开始

### 环境要求

- Node.js 14+
- npm 6+
- Java 17+
- Gradle 7+

### 后端服务启动

1. 进入后端项目目录
```bash
cd sse-demo
```

2. 构建项目
```bash
./gradlew build
```

3. 运行应用
```bash
./gradlew bootRun
```

后端服务将运行在 `http://localhost:8080`

### 前端应用启动

1. 进入前端项目目录
```bash
cd react-frontend
```

2. 安装依赖
```bash
npm install
```

3. 启动开发服务器
```bash
npm start
```

前端应用将运行在 `http://localhost:3000`

## 配置说明

### 后端配置

在 `sse-demo/src/main/resources/application.yml` 中配置Dify API相关信息：

```yaml
dify:
  api:
    url: http://192.168.141.145/v1/chat-messages  # Dify API地址
    key: app-yIyPvikvguW4Dc33rarl8ZqW             # Dify API密钥
```

### 前端配置

前端默认连接到 `http://localhost:8080`，如需修改API地址，请更新 [ChatComponent.tsx](file://D:\Developer\workspace\react-springbot-sse-chat\react-frontend\src\components\ChatComponent.tsx) 中的请求地址。

## API接口

### 聊天接口

```
POST /api/dify/chat/stream
Content-Type: application/json

{
  "message": "用户消息内容",
  "user": "用户标识",
  "conversationId": "可选的会话ID"
}
```

响应采用SSE流式传输，每条消息以`[DONE]`标记结束。

### 健康检查接口

```
GET /api/dify/health
```

## 核心功能详解

### 流式消息传输

应用使用Server-Sent Events (SSE) 实现实时消息传输，用户可以实时看到AI助手的回复逐步显示，提供更好的交互体验。

### 思考过程展示

AI助手消息中可能包含思考过程（用 `<think>...</think>` 标签包裹），前端会将这部分内容单独展示在"深度思考"区域，让用户了解AI的推理过程。

### 消息类型

- **用户消息**: 显示在右侧，蓝色背景
- **助手消息**: 显示在左侧，灰色背景，可能包含思考过程

## 开发指南

### 前端组件

- [ChatComponent.tsx](file://D:\Developer\workspace\react-springbot-sse-chat\react-frontend\src\components\ChatComponent.tsx): 主聊天组件，处理消息显示和用户交互
- [App.css](file://D:\Developer\workspace\react-springbot-sse-chat\react-frontend\src\App.css): 样式文件，包含消息样式、思考区域样式等

### 后端服务

- [DifyController.java](file://D:\Developer\workspace\react-springbot-sse-chat\sse-demo\src\main\java\cn\com\grandage\ssedemo\controller\DifyController.java): 处理聊天请求的控制器
- [DifyService.java](file://D:\Developer\workspace\react-springbot-sse-chat\sse-demo\src\main\java\cn\com\grandage\ssedemo\service\DifyService.java): 处理与Dify API的通信和SSE流处理
- [DifyRequest.java](file://D:\Developer\workspace\react-springbot-sse-chat\sse-demo\src\main\java\cn\com\grandage\ssedemo\dto\DifyRequest.java)/[DifyResponse.java](file://D:\Developer\workspace\react-springbot-sse-chat\sse-demo\src\main\java\cn\com\grandage\ssedemo\dto\DifyResponse.java): DTO对象

## 部署说明

### 后端部署

1. 构建可执行jar包：
```bash
cd sse-demo
./gradlew bootJar
```

2. 运行jar包：
```bash
java -jar build/libs/sse-demo-0.0.1-SNAPSHOT.jar
```

### 前端部署

1. 构建生产版本：
```bash
cd react-frontend
npm run build
```

2. 将build目录中的内容部署到Web服务器

## 注意事项

1. 需要有效的Dify API密钥才能运行后端服务
2. 确保前后端服务都在运行且网络连通
3. 浏览器需支持SSE (Server-Sent Events)

## 故障排除

### 常见问题

1. **无法连接到后端服务**
   - 检查后端服务是否正在运行
   - 确认端口配置是否正确
   - 检查防火墙设置

2. **消息无法发送**
   - 检查API密钥是否正确配置
   - 查看后端日志确认错误信息

3. **思考过程不显示**
   - 确认助手回复中包含 `<think>...</think>` 标签
   - 检查前端控制台是否有错误信息

## 许可证

本项目仅供宁波银行优云平台演示使用。

## 联系方式

如有问题，请联系项目维护团队。