package com.grandage.client.server;


import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.management.*;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.logging.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author zhaoxin
 * @data 2020/6/24
 */
@RestController
@RequestMapping("/jmx")
public class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getName());
    private static final String USAGE = "Usage: java -jar cmdline-jmxclient.jar USER:PASS HOST:PORT [BEAN] [COMMAND]\nOptions:\n USER:PASS Username and password. Required. If none, pass '-'.\n           E.g. 'controlRole:secret'\n HOST:PORT Hostname and port to connect to. Required. E.g. localhost:8081.\n           Lists registered beans if only USER:PASS and this argument.\n BEANNAME  Optional target bean name. If present we list available operations\n           and attributes.\n COMMAND   Optional operation to run or attribute to fetch. If none supplied,\n           all operations and attributes are listed. Attributes begin with a\n           capital letter: e.g. 'Status' or 'Started'. Operations do not.\n           Operations can take arguments by adding an '=' followed by\n           comma-delimited params. Pass multiple attributes/operations to run\n           more than one per invocation.\nRequirements:\n JDK1.5.0. If connecting to a SUN 1.5.0 JDK JMX Agent, remote side must be\n started with system properties such as the following:\n     -Dcom.sun.management.jmxremote.port=PORT\n     -Dcom.sun.management.jmxremote.authenticate=false\n     -Dcom.sun.management.jmxremote.ssl=false\n The above will start the remote server with no password. See\n http://java.sun.com/j2se/1.5.0/docs/guide/management/agent.html for more on\n 'Monitoring and Management via JMX'.\nClient Use Examples:\n To list MBeans on a non-password protected remote agent:\n     % java -jar cmdline-jmxclient-X.X.jar - localhost:8081 \\\n         org.archive.crawler:name=Heritrix,type=Service\n To list attributes and attributes of the Heritrix MBean:\n     % java -jar cmdline-jmxclient-X.X.jar - localhost:8081 \\\n         org.archive.crawler:name=Heritrix,type=Service \\\n         schedule=http://www.archive.org\n To set set logging level to FINE on a password protected JVM:\n     % java -jar cmdline-jmxclient-X.X.jar controlRole:secret localhost:8081 \\\n         java.util.logging:type=Logging \\\n         setLoggerLevel=org.archive.crawler.Heritrix,FINE";
    protected static final Pattern CMD_LINE_ARGS_PATTERN = Pattern.compile("^([^=]+)(?:(?:\\=)(.+))?$");
    static {
    }
    @PostMapping(value = "client")
    public synchronized String client(@RequestBody String[] args)throws Exception{
        Client client = new Client();
        Logger l = Logger.getLogger("");
        Handler[] hs = l.getHandlers();
        for(int i = 0; i < hs.length; ++i) {
            Handler h = hs[0];
            if (h instanceof ConsoleHandler) {
                h.setFormatter(client.new OneLineSimpleLogger());
            }
        }

        List<String> execute = client.execute(args);
        StringBuilder resultString = new StringBuilder();
        for (String s : execute) {
            resultString.append(s).append("\n");
        }
        return resultString.toString();
    }
    protected static List<String> usage() {
        List<String> usage = usage(0, (String) null);
        return usage;
    }

    protected static List<String> usage(int exitCode, String message) {
        List<String> usageString = new ArrayList<>();
        if (message != null && message.length() > 0) {
//            System.out.println(message);
            usageString.add(message);
        }

//        System.out.println("Usage: java -jar cmdline-jmxclient.jar USER:PASS HOST:PORT [BEAN] [COMMAND]\nOptions:\n USER:PASS Username and password. Required. If none, pass '-'.\n           E.g. 'controlRole:secret'\n HOST:PORT Hostname and port to connect to. Required. E.g. localhost:8081.\n           Lists registered beans if only USER:PASS and this argument.\n BEANNAME  Optional target bean name. If present we list available operations\n           and attributes.\n COMMAND   Optional operation to run or attribute to fetch. If none supplied,\n           all operations and attributes are listed. Attributes begin with a\n           capital letter: e.g. 'Status' or 'Started'. Operations do not.\n           Operations can take arguments by adding an '=' followed by\n           comma-delimited params. Pass multiple attributes/operations to run\n           more than one per invocation.\nRequirements:\n JDK1.5.0. If connecting to a SUN 1.5.0 JDK JMX Agent, remote side must be\n started with system properties such as the following:\n     -Dcom.sun.management.jmxremote.port=PORT\n     -Dcom.sun.management.jmxremote.authenticate=false\n     -Dcom.sun.management.jmxremote.ssl=false\n The above will start the remote server with no password. See\n http://java.sun.com/j2se/1.5.0/docs/guide/management/agent.html for more on\n 'Monitoring and Management via JMX'.\nClient Use Examples:\n To list MBeans on a non-password protected remote agent:\n     % java -jar cmdline-jmxclient-X.X.jar - localhost:8081 \\\n         org.archive.crawler:name=Heritrix,type=Service\n To list attributes and attributes of the Heritrix MBean:\n     % java -jar cmdline-jmxclient-X.X.jar - localhost:8081 \\\n         org.archive.crawler:name=Heritrix,type=Service \\\n         schedule=http://www.archive.org\n To set set logging level to FINE on a password protected JVM:\n     % java -jar cmdline-jmxclient-X.X.jar controlRole:secret localhost:8081 \\\n         java.util.logging:type=Logging \\\n         setLoggerLevel=org.archive.crawler.Heritrix,FINE");
        usageString.add("\"Usage: java -jar cmdline-jmxclient.jar USER:PASS HOST:PORT [BEAN] [COMMAND]\\nOptions:\\n USER:PASS Username and password. Required. If none, pass '-'.\\n           E.g. 'controlRole:secret'\\n HOST:PORT Hostname and port to connect to. Required. E.g. localhost:8081.\\n           Lists registered beans if only USER:PASS and this argument.\\n BEANNAME  Optional target bean name. If present we list available operations\\n           and attributes.\\n COMMAND   Optional operation to run or attribute to fetch. If none supplied,\\n           all operations and attributes are listed. Attributes begin with a\\n           capital letter: e.g. 'Status' or 'Started'. Operations do not.\\n           Operations can take arguments by adding an '=' followed by\\n           comma-delimited params. Pass multiple attributes/operations to run\\n           more than one per invocation.\\nRequirements:\\n JDK1.5.0. If connecting to a SUN 1.5.0 JDK JMX Agent, remote side must be\\n started with system properties such as the following:\\n     -Dcom.sun.management.jmxremote.port=PORT\\n     -Dcom.sun.management.jmxremote.authenticate=false\\n     -Dcom.sun.management.jmxremote.ssl=false\\n The above will start the remote server with no password. See\\n http://java.sun.com/j2se/1.5.0/docs/guide/management/agent.html for more on\\n 'Monitoring and Management via JMX'.\\nClient Use Examples:\\n To list MBeans on a non-password protected remote agent:\\n     % java -jar cmdline-jmxclient-X.X.jar - localhost:8081 \\\\\\n         org.archive.crawler:name=Heritrix,type=Service\\n To list attributes and attributes of the Heritrix MBean:\\n     % java -jar cmdline-jmxclient-X.X.jar - localhost:8081 \\\\\\n         org.archive.crawler:name=Heritrix,type=Service \\\\\\n         schedule=http://www.archive.org\\n To set set logging level to FINE on a password protected JVM:\\n     % java -jar cmdline-jmxclient-X.X.jar controlRole:secret localhost:8081 \\\\\\n         java.util.logging:type=Logging \\\\\\n         setLoggerLevel=org.archive.crawler.Heritrix,FINE\"");
        System.exit(exitCode);
        return usageString;
    }

    public Client() {
    }

    protected Map formatCredentials(String userpass) {
        Map env = null;
        if (userpass != null && !userpass.equals("-")) {
            int index = userpass.indexOf(58);
            if (index <= 0) {
                throw new RuntimeException("Unable to parse: " + userpass);
            } else {
                String[] creds = new String[]{userpass.substring(0, index), userpass.substring(index + 1)};
                env = new HashMap(1);
                env.put("jmx.remote.credentials", creds);
                return env;
            }
        } else {
            return env;
        }
    }

    protected List<String> execute(String[] args) throws Exception {
        List<String> executeString = new ArrayList<>();
        if (args.length == 0 || args.length == 1) {
            List<String> usage = usage();
            executeString.addAll(usage);
        }

        String userpass = args[0];
        String hostport = args[1];
        String beanName = null;
        String[] command = null;
        if (args.length > 2) {
            beanName = args[2];
        }

        if (args.length > 3) {
            command = new String[args.length - 3];

            for(int i = 3; i < args.length; ++i) {
                command[i - 3] = args[i];
            }
        }

        int index = hostport.indexOf(58);
        if (index > 0) {
            hostport.substring(0, index);
        }

        JMXServiceURL rmiurl = new JMXServiceURL("service:jmx:rmi://" + hostport + "/jndi/rmi://" + hostport + "/jmxrmi");
        JMXConnector jmxc = JMXConnectorFactory.connect(rmiurl, this.formatCredentials(userpass));

        try {
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            ObjectName objName = beanName != null && beanName.length() > 0 ? new ObjectName(beanName) : null;
            Set beans = mbsc.queryMBeans(objName, (QueryExp)null);
            if (beans.size() == 0) {
                logger.severe(objName.getCanonicalName() + " is not a registered bean");
            } else if (beans.size() == 1) {
                ObjectInstance instance = (ObjectInstance)beans.iterator().next();
                List<String> doBeanStrings = this.doBean(mbsc, instance, command);
                executeString.addAll(doBeanStrings);
            } else {
                Iterator i = beans.iterator();

                while(i.hasNext()) {
                    Object obj = i.next();
                    if (obj instanceof ObjectName) {
//                        System.out.println(((ObjectName)obj).getCanonicalName());
                        executeString.add(((ObjectName)obj).getCanonicalName());
                    } else if (obj instanceof ObjectInstance) {
//                        System.out.println(((ObjectInstance)obj).getObjectName().getCanonicalName());
                        executeString.add(((ObjectInstance)obj).getObjectName().getCanonicalName());
                    } else {
//                        logger.severe("Unexpected object type: " + obj);
                        executeString.add("Unexpected object type: " + obj);
                    }
                }
            }
        } finally {
            jmxc.close();
        }
                return executeString;
    }

    protected List<String> doBean(MBeanServerConnection mbsc, ObjectInstance instance, String[] command) throws Exception {
        List<String> doBeanString = new ArrayList<>();
        if (command != null && command.length > 0) {
            for(int i = 0; i < command.length; ++i) {
                List<String> doSubCommandStrings = this.doSubCommand(mbsc, instance, command[i]);
                doBeanString.addAll(doSubCommandStrings);
            }

        } else {
            List<String> listOptions = this.listOptions(mbsc, instance);
            doBeanString.addAll(listOptions);
        }
        return doBeanString;
    }

    protected List<String> doSubCommand(MBeanServerConnection mbsc, ObjectInstance instance, String subCommand) throws Exception {
        List<String> doSubCommandString = new ArrayList<>();
        MBeanAttributeInfo[] attributeInfo = mbsc.getMBeanInfo(instance.getObjectName()).getAttributes();
        MBeanOperationInfo[] operationInfo = mbsc.getMBeanInfo(instance.getObjectName()).getOperations();
        Object result = null;
        if (Character.isUpperCase(subCommand.charAt(0))) {
            if (!this.isFeatureInfo(attributeInfo, subCommand) && this.isFeatureInfo(operationInfo, subCommand)) {
                result = this.doBeanOperation(mbsc, instance, subCommand, operationInfo);
            } else {
                result = this.doAttributeOperation(mbsc, instance, subCommand, attributeInfo);
            }
        } else if (!this.isFeatureInfo(operationInfo, subCommand) && this.isFeatureInfo(attributeInfo, subCommand)) {
            result = this.doAttributeOperation(mbsc, instance, subCommand, attributeInfo);
        } else {
            result = this.doBeanOperation(mbsc, instance, subCommand, operationInfo);
        }

        if (result instanceof CompositeData) {
            result = this.recurseCompositeData(new StringBuffer("\n"), "", "", (CompositeData)result);
        } else if (result instanceof TabularData) {
            result = this.recurseTabularData(new StringBuffer("\n"), "", "", (TabularData)result);
        } else if (result instanceof String[]) {
            String[] strs = (String[])((String[])result);
            StringBuffer buffer = new StringBuffer("\n");

            for(int i = 0; i < strs.length; ++i) {
                buffer.append(strs[i]);
                buffer.append("\n");
            }

            result = buffer;
        }

        if (result != null && logger.isLoggable(Level.INFO)) {
//            logger.info(subCommand + ": " + result);
            doSubCommandString.add(result.toString());
        }
        return doSubCommandString;
    }

    protected boolean isFeatureInfo(MBeanFeatureInfo[] infos, String cmd) {
        return this.getFeatureInfo(infos, cmd) != null;
    }

    protected MBeanFeatureInfo getFeatureInfo(MBeanFeatureInfo[] infos, String cmd) {
        int index = cmd.indexOf(61);
        String name = index > 0 ? cmd.substring(0, index) : cmd;

        for(int i = 0; i < infos.length; ++i) {
            if (infos[i].getName().equals(name)) {
                return infos[i];
            }
        }

        return null;
    }

    protected StringBuffer recurseTabularData(StringBuffer buffer, String indent, String name, TabularData data) {
        this.addNameToBuffer(buffer, indent, name);
        Collection c = data.values();
        Iterator i = c.iterator();

        while(i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof CompositeData) {
                this.recurseCompositeData(buffer, indent + " ", "", (CompositeData)obj);
            } else if (obj instanceof TabularData) {
                this.recurseTabularData(buffer, indent, "", (TabularData)obj);
            } else {
                buffer.append(obj);
            }
        }

        return buffer;
    }

    protected StringBuffer recurseCompositeData(StringBuffer buffer, String indent, String name, CompositeData data) {
        indent = this.addNameToBuffer(buffer, indent, name);
        Iterator i = data.getCompositeType().keySet().iterator();

        while(i.hasNext()) {
            String key = (String)i.next();
            Object o = data.get(key);
            if (o instanceof CompositeData) {
                this.recurseCompositeData(buffer, indent + " ", key, (CompositeData)o);
            } else if (o instanceof TabularData) {
                this.recurseTabularData(buffer, indent, key, (TabularData)o);
            } else {
                buffer.append(indent);
                buffer.append(key);
                buffer.append(": ");
                buffer.append(o);
                buffer.append("\n");
            }
        }

        return buffer;
    }

    protected String addNameToBuffer(StringBuffer buffer, String indent, String name) {
        if (name != null && name.length() != 0) {
            buffer.append(indent);
            buffer.append(name);
            buffer.append(":\n");
            return indent + " ";
        } else {
            return indent;
        }
    }

    protected Object doAttributeOperation(MBeanServerConnection mbsc, ObjectInstance instance, String command, MBeanAttributeInfo[] infos) throws Exception {
        Client.CommandParse parse = new Client.CommandParse(command);
        if (parse.getArgs() != null && parse.getArgs().length != 0) {
            if (parse.getArgs().length != 1) {
                throw new IllegalArgumentException("One only argument setting attribute values: " + parse.getArgs());
            } else {
                MBeanAttributeInfo info = (MBeanAttributeInfo)this.getFeatureInfo(infos, parse.getCmd());
                Constructor c = Class.forName(info.getType()).getConstructor(String.class);
                Attribute a = new Attribute(parse.getCmd(), c.newInstance(parse.getArgs()[0]));
                mbsc.setAttribute(instance.getObjectName(), a);
                return null;
            }
        } else {
            return mbsc.getAttribute(instance.getObjectName(), parse.getCmd());
        }
    }

    protected Object doBeanOperation(MBeanServerConnection mbsc, ObjectInstance instance, String command, MBeanOperationInfo[] infos) throws Exception {
        Client.CommandParse parse = new Client.CommandParse(command);
        MBeanOperationInfo op = (MBeanOperationInfo)this.getFeatureInfo(infos, parse.getCmd());
        Object result = null;
        if (op == null) {
            result = "Operation " + parse.getCmd() + " not found.";
        } else {
            MBeanParameterInfo[] paraminfos = op.getSignature();
            int paraminfosLength = paraminfos == null ? 0 : paraminfos.length;
            int objsLength = parse.getArgs() == null ? 0 : parse.getArgs().length;
            if (paraminfosLength != objsLength) {
                result = "Passed param count does not match signature count";
            } else {
                String[] signature = new String[paraminfosLength];
                Object[] params = paraminfosLength == 0 ? null : new Object[paraminfosLength];

                for(int i = 0; i < paraminfosLength; ++i) {
                    MBeanParameterInfo paraminfo = paraminfos[i];
                    Constructor c = Class.forName(paraminfo.getType()).getConstructor(String.class);
                    params[i] = c.newInstance(parse.getArgs()[i]);
                    signature[i] = paraminfo.getType();
                }

                result = mbsc.invoke(instance.getObjectName(), parse.getCmd(), params, signature);
            }
        }

        return result;
    }

    protected List<String> listOptions(MBeanServerConnection mbsc, ObjectInstance instance) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        List<String> OptionsString = new ArrayList<>();
        MBeanInfo info = mbsc.getMBeanInfo(instance.getObjectName());
        MBeanAttributeInfo[] attributes = info.getAttributes();
        if (attributes.length > 0) {
//            System.out.println("Attributes:");
            OptionsString.add("Attributes:");
            for(int i = 0; i < attributes.length; ++i) {
//                System.out.println(' ' + attributes[i].getName() + ": " + attributes[i].getDescription() + " (type=" + attributes[i].getType() + ")");
                OptionsString.add(' ' + attributes[i].getName() + ": " + attributes[i].getDescription() + " (type=" + attributes[i].getType() + ")");
            }
        }

        MBeanOperationInfo[] operations = info.getOperations();
        if (operations.length > 0) {
//            System.out.println("Operations:");
            OptionsString.add("Operations:");
            for(int i = 0; i < operations.length; ++i) {
                MBeanParameterInfo[] params = operations[i].getSignature();
                StringBuffer paramsStrBuffer = new StringBuffer();
                if (params != null) {
                    for(int j = 0; j < params.length; ++j) {
                        paramsStrBuffer.append("\n   name=");
                        paramsStrBuffer.append(params[j].getName());
                        paramsStrBuffer.append(" type=");
                        paramsStrBuffer.append(params[j].getType());
                        paramsStrBuffer.append(" ");
                        paramsStrBuffer.append(params[j].getDescription());
                    }
                }

//                System.out.println(' ' + operations[i].getName() + ": " + operations[i].getDescription() + "\n  Parameters " + params.length + ", return type=" + operations[i].getReturnType() + paramsStrBuffer.toString());
                OptionsString.add(' ' + operations[i].getName() + ": " + operations[i].getDescription() + "\n  Parameters " + params.length + ", return type=" + operations[i].getReturnType() + paramsStrBuffer.toString());
            }
        }
        return OptionsString;
    }

    private class OneLineSimpleLogger extends SimpleFormatter {
        private Date date = new Date();
        private FieldPosition position = new FieldPosition(0);
        private SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss Z");
        private StringBuffer buffer = new StringBuffer();

        public OneLineSimpleLogger() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            this.buffer.setLength(0);
            this.date.setTime(record.getMillis());
            this.position.setBeginIndex(0);
            this.formatter.format(this.date, this.buffer, this.position);
            this.buffer.append(' ');
            if (record.getSourceClassName() != null) {
                this.buffer.append(record.getSourceClassName());
            } else {
                this.buffer.append(record.getLoggerName());
            }

            this.buffer.append(' ');
            this.buffer.append(this.formatMessage(record));
            this.buffer.append(System.getProperty("line.separator"));
            if (record.getThrown() != null) {
                try {
                    StringWriter writer = new StringWriter();
                    PrintWriter printer = new PrintWriter(writer);
                    record.getThrown().printStackTrace(printer);
                    writer.close();
                    this.buffer.append(writer.toString());
                } catch (Exception var4) {
                    this.buffer.append("Failed to get stack trace: " + var4.getMessage());
                }
            }

            return this.buffer.toString();
        }
    }

    protected class CommandParse {
        private String cmd;
        private String[] args;

        protected CommandParse(String command) throws ParseException {
            this.parse(command);
        }

        private void parse(String command) throws ParseException {
            Matcher m = Client.CMD_LINE_ARGS_PATTERN.matcher(command);
            if (m != null && m.matches()) {
                this.cmd = m.group(1);
                if (m.group(2) != null && m.group(2).length() > 0) {
                    this.args = m.group(2).split(",");
                } else {
                    this.args = null;
                }

            } else {
                throw new ParseException("Failed parse of " + command, 0);
            }
        }

        protected String getCmd() {
            return this.cmd;
        }

        protected String[] getArgs() {
            return this.args;
        }
    }
}
